export function colorSwatch() {
    const colorsElements = document.querySelectorAll("[data-colors]");    

    colorsElements.forEach(colorElement => {
        if (colorElement.dataset.colors) {
            let colors = colorElement.dataset.colors;
                colors = colors.split("/");

                for (let i = 0; i < colors.length; i++) {
                    createCircle(colorElement, colors[i], i);
                }
            
        }
    });
}

export function validateEditBtn() {
    const editBtn = document.getElementById("edit-theme-btn");
    const editRadios = document.querySelectorAll("[name='theme-radio']"); 
    const previewBtn = document.getElementById("preview-theme-btn");
    const removeRadioSelectionBtn = document.getElementById("remove-radio-selection");    

    removeRadioSelectionBtn.addEventListener("click", function(ev) {
        ev.preventDefault();

        for (let i=0; i < editRadios.length; i++) {
            if (editRadios[i].checked) {
                editRadios[i].checked = false;
                editBtn.classList.add("disabled");
                previewBtn.classList.add("disabled");
            }
        }
    });
}

export function openThemeModal() {
    const themeBtns = document.querySelectorAll(".theme-action-btn");
    const modalHeader = document.querySelector("#modal-theme > .header");
    
    themeBtns.forEach(themeBtn => {
        themeBtn.addEventListener("click", function(ev) {
            ev.preventDefault();
            
            if (ev.currentTarget.getAttribute("id") === "new-theme-btn") {
                modalHeader.innerHTML = "<i class='theme icon'></i>Criar novo tema"                
            }
            else if (ev.currentTarget.getAttribute("id") === "edit-theme-btn") {
                modalHeader.innerHTML = "<i class='edit icon'></i>Editar tema escolhido";
            }
            
            $("#modal-theme").modal("show");
        });
    });

}

export function selectThemeTableRow() {
    const themeTableRows = document.querySelectorAll("#theme-table > tbody > tr");
    const editBtn = document.getElementById("edit-theme-btn");
    const previewBtn = document.getElementById("preview-theme-btn");

    themeTableRows.forEach(themeTableRow => {
        themeTableRow.addEventListener("click", function(ev) {
            ev.preventDefault();
            const radio = ev.currentTarget.firstElementChild.firstElementChild.firstElementChild;

            if (radio) {
                radio.checked = true;
                editBtn.classList.remove("disabled");
                previewBtn.classList.remove("disabled");
            }
        });
    });
}

/**
 * 
 * @param {DOM element} target elemento no qual o círculo será adicionado
 * @param {string} bgColor cor que será aplicada ao background-color do círculo
 * @param {number} index index do elemento atual
 */
function createCircle(target, bgColor, index) {
    const circle = document.createElement("span");

    circle.style.position = "relative";
    circle.style.width = "1.5rem";
    circle.style.height = "1.5rem";
    circle.style.marginRight = ".5rem";
    circle.style.borderRadius = "50%";
    circle.style.backgroundColor = bgColor;
    circle.style.boxShadow = "0 2px 4px rgba(0,0,0,.25)";
    circle.style.display = "inline-block";

    circle.classList.add("popup");

    circle.setAttribute("data-content", bgColor.toUpperCase());

    switch (index) {
        case 0:
            circle.setAttribute("data-title", "Cor primária");
            break;
        case 1:
            circle.setAttribute("data-title", "Cor secundária");
            break;
        case 2:
            circle.setAttribute("data-title", "Cor de destaque");
            break;
        case 3:
            circle.setAttribute("data-title", "Cor suave");
            break;
        case 4:
            circle.setAttribute("data-title", "Cor para texto");
            break;
        case 5:
            circle.setAttribute("data-title", "Cor para sombreamento de caixa");
            break;
    }
    
    target.appendChild(circle);
}